/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpResponse;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.Tls12Java7SocketFactory;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class HttpConnector
implements WsConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    public static final String[] TLS_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private final HttpUrl baseUrl;
    private final String userAgent;
    private final String credentials;
    private final String proxyCredentials;
    private final OkHttpClient okHttpClient = new OkHttpClient();

    private HttpConnector(Builder builder, JavaVersion javaVersion) {
        this.baseUrl = HttpUrl.parse(builder.url.endsWith("/") ? builder.url : String.format("%s/", builder.url));
        this.userAgent = builder.userAgent;
        this.credentials = Strings.isNullOrEmpty(builder.login) ? null : Credentials.basic(builder.login, Strings.nullToEmpty(builder.password));
        if (builder.proxy != null) {
            this.okHttpClient.setProxy(builder.proxy);
        }
        this.proxyCredentials = Strings.isNullOrEmpty(builder.proxyLogin) ? null : Credentials.basic(builder.proxyLogin, Strings.nullToEmpty(builder.proxyPassword));
        this.okHttpClient.setConnectTimeout(builder.connectTimeoutMs, TimeUnit.MILLISECONDS);
        this.okHttpClient.setReadTimeout(builder.readTimeoutMs, TimeUnit.MILLISECONDS);
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().supportsTlsExtensions(true).build();
        this.okHttpClient.setConnectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        if (javaVersion.isJava7()) {
            try {
                this.okHttpClient.setSslSocketFactory(new Tls12Java7SocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to init TLS context", e);
            }
        }
    }

    @Override
    public String baseUrl() {
        return this.baseUrl.url().toExternalForm();
    }

    @CheckForNull
    public String userAgent() {
        return this.userAgent;
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    @Override
    public WsResponse call(WsRequest httpRequest) {
        if (httpRequest instanceof GetRequest) {
            return this.get((GetRequest)httpRequest);
        }
        if (httpRequest instanceof PostRequest) {
            return this.post((PostRequest)httpRequest);
        }
        throw new IllegalArgumentException(String.format("Unsupported implementation: %s", httpRequest.getClass()));
    }

    private WsResponse get(GetRequest getRequest) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(getRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(getRequest, urlBuilder).get();
        return this.doCall(okRequestBuilder.build());
    }

    private WsResponse post(PostRequest postRequest) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(postRequest);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(postRequest, urlBuilder);
        Map<String, PostRequest.Part> parts = postRequest.getParts();
        if (parts.isEmpty()) {
            okRequestBuilder.post(RequestBody.create(null, ""));
        } else {
            MultipartBuilder body = new MultipartBuilder().type(MultipartBuilder.FORM);
            for (Map.Entry<String, PostRequest.Part> param : parts.entrySet()) {
                PostRequest.Part part = param.getValue();
                body.addPart(Headers.of("Content-Disposition", String.format("form-data; name=\"%s\"", param.getKey())), RequestBody.create(MediaType.parse(part.getMediaType()), part.getFile()));
            }
            okRequestBuilder.post(body.build());
        }
        return this.doCall(okRequestBuilder.build());
    }

    private HttpUrl.Builder prepareUrlBuilder(WsRequest wsRequest) {
        String path = wsRequest.getPath();
        HttpUrl.Builder urlBuilder = this.baseUrl.resolve(path.startsWith("/") ? path.replaceAll("^(/)+", "") : path).newBuilder();
        for (Map.Entry<String, String> param : wsRequest.getParams().entrySet()) {
            urlBuilder.addQueryParameter(param.getKey(), param.getValue());
        }
        return urlBuilder;
    }

    private Request.Builder prepareOkRequestBuilder(WsRequest getRequest, HttpUrl.Builder urlBuilder) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(urlBuilder.build()).addHeader("Accept", getRequest.getMediaType()).addHeader("Accept-Charset", "UTF-8");
        if (this.credentials != null) {
            okHttpRequestBuilder.header("Authorization", this.credentials);
        }
        if (this.proxyCredentials != null) {
            okHttpRequestBuilder.header("Proxy-Authorization", this.proxyCredentials);
        }
        if (this.userAgent != null) {
            okHttpRequestBuilder.addHeader("User-Agent", this.userAgent);
        }
        return okHttpRequestBuilder;
    }

    private HttpResponse doCall(Request okRequest) {
        Call call = this.okHttpClient.newCall(okRequest);
        try {
            Response okResponse = call.execute();
            return new HttpResponse(okResponse);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request " + okRequest.urlString(), e);
        }
    }

    static class JavaVersion {
        JavaVersion() {
        }

        boolean isJava7() {
            return System.getProperty("java.version").startsWith("1.7.");
        }
    }

    public static class Builder {
        private String url;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public HttpConnector build() {
            return this.build(new JavaVersion());
        }

        @VisibleForTesting
        HttpConnector build(JavaVersion javaVersion) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.url), "Server URL is not defined");
            return new HttpConnector(this, javaVersion);
        }
    }
}

